using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace Windows_Explorer_Layout {
	public class ColumnLayoutControl : System.Windows.Forms.UserControl {
		private const int COLUMN_SPACING = 15;

		private System.ComponentModel.Container components = null;

		public ColumnLayoutControl() {
			InitializeComponent();

			Layout += new LayoutEventHandler(ColumnLayoutControl_Layout);
		}

		protected override void Dispose( bool disposing ) {
			if( disposing ) {
				if(components != null) {
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent() {
			// 
			// ColumnLayoutControl
			// 
			this.AutoScroll = true;
			this.BackColor = System.Drawing.SystemColors.Window;
			this.Name = "ColumnLayoutControl";

		}
		#endregion

		/// <summary>
		/// Add the specified control.  Use this instead of Controls.Add to 
		/// make sure appropriate event handlers get installed.
		/// </summary>
		public void Add(Control item) {
			Controls.Add(item);
			item.Click += new EventHandler(ColumnLayoutControl_Click);
		}

		/// <summary>
		/// Layout all child controls in multiple columns with all having the same width
		/// equal to the maximum width of any child.
		/// </summary>
		private void ColumnLayoutControl_Layout(object sender, LayoutEventArgs e) {
			SuspendLayout();

			// First, find max width of child controls
			int maxWidth = 0;
			foreach (Control control in Controls) {
				maxWidth = Math.Max(maxWidth, control.Width);
			}

			// Then, layout out controls vertically in columns
			int x = 0;
			int y = 0;
			foreach (Control item in Controls) {
				if ((y + item.Height) > ClientSize.Height) {
					x += maxWidth + COLUMN_SPACING;
					y = 0;
				}
				item.Location = new Point(x, y);
				y += item.Height;
			}

			ResumeLayout();
		}

		/// <summary>
		/// Simple interaction to select the single item clicked on.
		/// </summary>
		private void ColumnLayoutControl_Click(object sender, EventArgs e) {
			foreach (Control item in Controls) {
				item.BackColor = Color.White;
				item.ForeColor = Color.Black;
			}

			(sender as Control).BackColor = SystemColors.Highlight;
			(sender as Control).ForeColor = SystemColors.HighlightText;
		}
	}
}